unit SSMouse;

interface

function InitMouse(var Buttons: Integer): Boolean;
procedure MouseStatus(var X, Y: Integer; var Left, Middle, Right: Boolean);

var
  Buttons: Integer;
  MouseInstalled: Boolean;

implementation

function InitMouse;
var
  MseExist, MseBtns : Integer;
begin
  asm
    mov ax, $0                  {Set Register AX to 0}
    int $33                     {Call Mouse Interrupt}
    cmp ax, 0                   {Is AX Register 0?}
    jnz @@MseExist              {If yes carry on, if non-zero jump}
    mov [MseBtns], 0            {Set Variable 'MseBtns' to 0}
    mov [MseExist], 0           {Set Variable MseExist to 0}
    jmp @@ExitCode              {Jump to end of code}
  @@MseExist:                   {Label 'MseExist'}
    mov [MseExist], -1          {Set Variable 'MseExist' to -1}
    mov [MseBtns], bx           {Set Variable 'MseBtns' to BX Register}
  @@ExitCode:                   {Label 'ExitCode'}
  end;
  InitMouse := (MseExist = -1); {if 'MseExist' = -1, set InitMouse to True}
  Buttons := MseBtns;           {Set 'Buttons' to 'MseBtns'}
end;

procedure MouseStatus;
var
  Xt, Yt, Tt : Integer;
  Temp : Integer;
begin
  asm
    mov ax, $3
    int $33
    mov [Tt], bx
    mov [Xt], cx
    mov [Yt], dx
  end;
  Left := ((Tt and 1) = 1);
  Right := ((Tt and 2) = 2);
  Middle := ((Tt and 4) = 4);
  X := Xt;
  Y := Yt;
end;

begin
  WriteLn('Initializing Mouse Driver...');
  MouseInstalled := InitMouse(Buttons);
end.