{$G+}
unit Graph256;

interface

const
  Red = 0;
  Green = 1;
  Blue = 2;
  GetMaxX = 319;
  GetMaxY = 199;

type
  PagePtr = ^PageType;
  PageType = array[0..63999] of Byte;
  PaletteType = array[0..255, Red..Blue] of Byte;

procedure VRetrace;
procedure VGAMode;
procedure TextScrn;
procedure Cls(var Page: PagePtr; Clr: Byte);
procedure PutPixel(var Page: PagePtr; X, Y: Integer; Clr: Byte);
function GetPixel(Page: PagePtr; X, Y: Integer): Byte;
procedure SetColour(ColourNum, Red, Green, Blue: Byte);
procedure GetColour(ColourNum: Byte; var Red, Green, Blue: Byte);
procedure SetPalette(Palette: PaletteType);
procedure ScreenCopy(NewPage: PagePtr; FadeMode: Byte);
procedure LoadTGA(FileName: String; var Palette: PaletteType;
                  var Page: PagePtr; X, Y: Integer);
procedure RotatePalU(var Palette: PaletteType; Start, Stop: Byte);
procedure RotatePalD(var Palette: PaletteType; Start, Stop: Byte);
procedure Rectangle(var Page: PagePtr; x1, y1, x2, y2: Integer; Clr: Byte);
procedure SetCursor(Mode: Byte);
procedure CursorOn;
procedure CursorOff;

const
  ScreenPage: PagePtr = Ptr($A000,0000);

var
  RealPage: array[0..63999] of Byte absolute $A000:0000;

implementation

uses Crt;

procedure CursorOn; assembler;
asm
  mov ah, 1
  mov cl, 1
  int 10h
end;

procedure CursorOff; assembler;
asm
  mov ah, 1
  mov cl, 0
  int 10h
end;

procedure SetCursor(Mode: Byte); assembler;
asm
  mov ah, 1
  mov ch, Mode
  mov cl, 1
  int 10h
end;

{Waits for Vertical Retrace}
procedure VRetrace;
begin
  repeat until (Port[$3DA] and 8) = 8;
end;

{This procedure gets you into 320x200x256 mode.}
procedure VGAMode;
begin
  asm
    mov ax, 13h
    int 10h
  end;
end;

{This procedure returns you to text mode.}
procedure TextScrn;
begin
  asm
    mov ax, 3h
    int 10h
  end;
end;

{Clears Page to the specified color}
procedure Cls(var Page: PagePtr; Clr: Byte);
begin
  FillChar(Page^, 64000, Clr);
end;

function CalcCoord(X, Y: Word): Word;
begin
  asm
    mov ax, Y
    shl ax, 8
    mov bx, Y
    shl bx, 6
    add ax, bx
    add ax, X
    mov @Result, ax
    {X + (Y * 320)}
  end;
end;

{Puts pixel of colour Clr, at position X,Y in Page}
procedure PutPixel(var Page: PagePtr; X, Y: Integer; Clr: Byte);
begin
  if (X >= 0) and (Y >= 0) and (X <= 319) and (Y <= 199) then
    Page^[CalcCoord(X, Y)] := Clr;
end;

{Puts pixel of colour Clr, at position X,Y in Page}
function GetPixel(Page: PagePtr; X, Y: Integer): Byte;
begin
  GetPixel := Page^[CalcCoord(X, Y)];
end;

{Set Colour ColourNum to RGB colour of Red, Green and Blue}
procedure SetColour(ColourNum, Red, Green, Blue: Byte);
begin
  asm
    mov dx,3c8h
    mov al,[ColourNum]
    out dx,al
    inc dx
    mov al,[Red]
    out dx,al
    mov al,[Green]
    out dx,al
    mov al,[Blue]
    out dx,al
  end;
end;

{Get Colour ColourNum}
procedure GetColour(ColourNum: Byte; var Red, Green, Blue: Byte);
var
  R, G,B: Byte;
begin
  asm
    mov dx, 3c7h
    mov al, [ColourNum]
    out dx, al
    inc dx
    inc dx
    in al, dx
    mov [R], al
    in al, dx
    mov [G], al
    in al, dx
    mov [B], al
  end;
  Red := R;
  Green := G;
  Blue := B;
end;

{Loads specified Palette into memory}
procedure SetPalette(Palette: PaletteType);
var
  Loop: Byte;
begin
  for Loop := 0 to 255 do
    SetColour(Loop, Palette[Loop, Red], Palette[Loop, Green],
              Palette[Loop, Blue]);
end;

{Rotates the current palette Up}
procedure RotatePalU(var Palette: PaletteType; Start, Stop: Byte);
var
  Loop, Loop2: Byte;
  Temp: record R, G, B: Byte; end;
begin
  Temp.R := Palette[Start, Red];
  Temp.G := Palette[Start, Green];
  Temp.B := Palette[Start, Blue];
  for Loop := Start to (Stop - 1) do
    for Loop2 := 0 to 2 do
      Palette[Loop, Loop2] := Palette[Loop + 1, Loop2];
  Palette[Stop, Red] := Temp.R;
  Palette[Stop, Green] := Temp.G;
  Palette[Stop, Blue] := Temp.B;
  SetPalette(Palette);
end;

procedure RotatePalD(var Palette: PaletteType; Start, Stop: Byte);
var
  Loop, Loop2: Byte;
  Temp: record R, G, B: Byte; end;
begin
  Temp.R := Palette[Stop, Red];
  Temp.G := Palette[Stop, Green];
  Temp.B := Palette[Stop, Blue];
  for Loop := Stop downto (Start + 1) do
    for Loop2 := 0 to 2 do
      Palette[Loop, Loop2] := Palette[Loop - 1, Loop2];
  Palette[Start, Red] := Temp.R;
  Palette[Start, Green] := Temp.G;
  Palette[Start, Blue] := Temp.B;
  SetPalette(Palette);
end;

procedure ScreenCopy(NewPage: PagePtr; FadeMode: Byte);
var
  LoopX, LoopY: LongInt;
  Radius, LocX, LocY, InX, InY: Integer;
begin
  case FadeMode of
    1: for LoopX := 0 to 319 do     {Right Copy}
       begin
         for LoopY := 0 to 199 do
           RealPage[CalcCoord(LoopX, LoopY)] := NewPage^[CalcCoord(LoopX, LoopY)];
         Delay(5);
       end;
    2: for LoopX := 319 downto 0 do  {Left Copy}
       begin
         for LoopY := 0 to 199 do
           RealPage[CalcCoord(LoopX, LoopY)] := NewPage^[CalcCoord(LoopX, LoopY)];
         Delay(5);
       end;
    3: for LoopY := 0 to 199 do      {Down Copy}
       begin
         for LoopX := 0 to 319 do
           RealPage[CalcCoord(LoopX, LoopY)] := NewPage^[CalcCoord(LoopX, LoopY)];
         Delay(5);
       end;
    4: for LoopY := 199 downto 0 do  {Up Copy}
       begin
         for LoopX := 0 to 319 do
           RealPage[CalcCoord(LoopX, LoopY)] := NewPage^[CalcCoord(LoopX, LoopY)];
         Delay(5);
       end;
    5: begin                         {Square Copy}
         for Radius := 0 to 15 do
           for LoopX := 0 to 19 do
             for LoopY := 0 to 15 do
             begin
               LocX := (16 * LoopX);
               LocY := (13 * LoopY);
               for InX := LocX to LocX + Radius do
                 RealPage[CalcCoord(InX, LocY + Radius)] := NewPage^[CalcCoord(InX, LocY + Radius)];
               for InY := LocY to LocY + Radius do
                 RealPage[CalcCoord(LocX + Radius, InY)] := NewPage^[CalcCoord(LocX + Radius, InY)];
             end;
       end;
    6: for LoopX := 0 to 1000000 do  {Random Fill Copy}
       begin
         LocX := Random(320);
         LocY := Random(200);
         RealPage[CalcCoord(LocX, LocY)] := NewPage^[CalcCoord(LocX, LocY)];
       end;
  else
    ScreenPage^ := NewPage^; {Straight Copy}
  end;
end;

{ Load 256 Colour Targa }
procedure LoadTGA(FileName: String; var Palette: PaletteType;
                  var Page: PagePtr; X, Y: Integer);
var
  TGAFile: File;
  TempPalAndHeadPtr: Pointer;
  vSeg, vOfs: Word;
  LoopX, LoopY: Word;
  Buffer: array[0..15240] of Char;
  NumRead: Word;
  DeltaX, DeltaY: Word;
  Loop: LongInt;
begin
  Assign(TGAFile, FileName);
  Reset(TGAFile, 1);
  GetMem(TempPalAndHeadPtr, 786);
  BlockRead(TGAFile, TempPalAndHeadPtr^, 786);
  vSeg := Seg(TempPalAndHeadPtr^);
  vOfs := Ofs(TempPalAndHeadPtr^);
  DeltaX := (Mem[vSeg:vOfs + 13] shl 8) + Mem[vSeg:vOfs + 12] - 1;
  DeltaY := (Mem[vSeg:vOfs + 15] shl 8) + Mem[vSeg:vOfs + 14] - 1;
  FreeMem(TempPalAndHeadPtr, 786);
  Seek(TGAFile, 786);
  vOfs := vOfs + 18;
  for LoopX := 0 to 255 do
  begin
    Palette[LoopX, Blue] := Mem[vSeg:vOfs] shr 2;
    vOfs := vOfs + 1;
    Palette[LoopX, Green] := Mem[vSeg:vOfs] shr 2;
    vOfs := vOfs + 1;
    Palette[LoopX, Red] := Mem[vSeg:vOfs] shr 2;
    vOfs := vOfs + 1;
  end;
  LoopY := 0;
  LoopX := 0;
  while LoopY <= DeltaY do
  begin
    BlockRead(TGAFile, Buffer, 15240, NumRead);
    for Loop := 1 to NumRead do
    begin
      PutPixel(Page, LoopX + X, DeltaY + Y - LoopY, Ord(Buffer[Loop - 1]));
      LoopX := LoopX + 1;
      if LoopX > DeltaX then
      begin
        LoopX := 0;
        LoopY := LoopY + 1;
      end;
    end;
  end;
  Close(TGAFile);
end;

procedure Swap(var A, B: Integer);
var
  C: Word;
begin
  C := A;
  A := B;
  B := C;
end;

procedure Rectangle(var Page: PagePtr; x1, y1, x2, y2: Integer; Clr: Byte);
var
  LoopX, LoopY: Word;
begin
  if x1 < 0 then x1 := 0;
  if x2 < 0 then x2 := 0;
  if y1 < 0 then y1 := 0;
  if y2 < 0 then y2 := 0;
  if x1 > GetMaxX then x1 := GetMaxX;
  if x2 > GetMaxX then x2 := GetMaxX;
  if y1 > GetMaxY then y1 := GetMaxY;
  if y2 > GetMaxY then y2 := GetMaxY;
  if x1 > x2 then Swap(x1, x2);
  if y1 > y2 then Swap(y1, y2);
  for LoopX := x1 to x2 do
    for LoopY := y1 to y2 do
      PutPixel(Page, LoopX, LoopY, Clr);
end;

begin
end.