program Black_Hole_Screen_Saver;

uses Graph256, SSMouse, Crt;

const
  NumStars = 700;
  Mode = Byte(0); {0}
  EventHorizon = Byte(7); {7}
  Gravity = 4; {4}
  RotationSpeed = Byte(3); {3}
  ColourScheme = Byte(6); {6}
  StopSpeed = Byte(2); {2}
  Swerve = True;
  PulsePal = True;
  Shimmer = False;
  Move = False;

type
  StarRec = record
              Distance: Word;
              Angle, Speed: Real;
            end;
  StarType = array[1..NumStars] of StarRec;
  LookupTable = array[0..718] of Real;

var
  VirtualPage: PagePtr;
  SinTable, CosTable: LookupTable;
  CenterX, CenterY: Word;

procedure InitTables(var SinTable, CosTable: LookupTable);
var Loop: Word;
begin
  for Loop := 0 to 718 do
  begin
    SinTable[Loop] := Sin((Loop / 2) / 180 * Pi);
    CosTable[Loop] := Cos((Loop / 2) / 180 * Pi);
  end;
end;

procedure NewStar(var Star: StarRec; SwerveAngle: Word);
var
  MaxDist: Word;
begin
  Star.Speed := SinTable[SwerveAngle] * RotationSpeed;
  Star.Angle := Random(718);
  if (GetMaxX - CenterX) < CenterX then
    MaxDist := CenterX
  else
    MaxDist := (GetMaxX - CenterX);
  Star.Distance := Random(MaxDist + 30) + EventHorizon;
end;

procedure Validate(var Angle: Integer);
begin
  while Angle < 0 do
    Angle := Angle + 718;
end;

function ExitRequired(OMX, OMY: Integer): Boolean;
var
  MX, MY: Integer;
  MLeft, MRight, MMiddle: Boolean;
begin
  ExitRequired := False;
  if KeyPressed then ExitRequired := True;
  if MouseInstalled then
  begin
    MouseStatus(MX, MY, MLeft, MMiddle, MRight);
    if MLeft or MMiddle or MRight then ExitRequired := True;
    if (MX <> OMX) or (MY <> OMY) then ExitRequired := True;
  end;
end;

procedure BlackHole;
var
  Palette: PaletteType;
  Stars: StarType;
  Loop, XPos, YPos, TempHorizon: Word;
  MLeft, MRight, MMiddle: Boolean;
  OMX, OMY: Integer;
  QuitLoop: Boolean;
  SwerveAngle, SA2: Word;
  Speed, MomentumDiv: Real;
  TempAngle: Integer;
  PulseUp: Boolean;
  PalCount: Byte;

  procedure InitPalette;
  var
    Loop: Byte;
  begin
    Palette[0, 0] := 0;
    Palette[0, 1] := 0;
    Palette[0, 2] := 0;
    for Loop := 1 to 255 do
      case ColourScheme of
        0: begin
             Palette[Loop, 0] := Loop div 4;
             Palette[Loop, 1] := Loop div 4;
             Palette[Loop, 2] := Loop div 4;
           end;
        1: begin
             Palette[Loop, 0] := 0;
             Palette[Loop, 1] := Loop div 4;
             Palette[Loop, 2] := Loop div 4;
           end;
        2: begin
             Palette[Loop, 0] := Loop div 4;
             Palette[Loop, 1] := 0;
             Palette[Loop, 2] := Loop div 4;
           end;
        3: begin
             Palette[Loop, 0] := Loop div 4;
             Palette[Loop, 1] := Loop div 4;
             Palette[Loop, 2] := 0;
           end;
        4: begin
             Palette[Loop, 0] := Loop div 7;
             Palette[Loop, 1] := Loop div 7;
             Palette[Loop, 2] := Loop div 4;
           end;
        5: begin
             if Loop < 50 then
             begin
               Palette[Loop, 0] := Trunc(Loop / 50 * 10);
               Palette[Loop, 1] := Trunc(Loop / 50 * 10);
               Palette[Loop, 2] := Loop;
             end
             else
             begin
               Palette[Loop, 0] := (Loop - 10) div 4;
               Palette[Loop, 1] := (Loop - 10) div 4;
               Palette[Loop, 2] := 63;
             end;
           end;
        6: begin
             case Loop of
                 0..39: begin
                          Palette[Loop, 0] := Trunc(63 / 40 * Loop);
                          Palette[Loop, 1] := 0;
                          Palette[Loop, 2] := 0;
                        end;
                40..79: begin
                          Palette[Loop, 0] := 63;
                          Palette[Loop, 1] := Trunc(63 / 40 * (Loop - 40));
                          Palette[Loop, 2] := 0;
                        end;
               80..129: begin
                          Palette[Loop, 0] := 63 - Trunc(63 / 50 * (Loop - 80));
                          Palette[Loop, 1] := 63;
                          Palette[Loop, 2] := 0;
                        end;
              130..199: begin
                          Palette[Loop, 0] := 0;
                          Palette[Loop, 1] := 63 - Trunc(63 / 70 * (Loop - 130));
                          Palette[Loop, 2] := Trunc(63 / 70 * (Loop - 130));
                        end;
              200..227: begin
                          Palette[Loop, 0] := Trunc(63 / 27 * (Loop - 200));
                          Palette[Loop, 1] := 0;
                          Palette[Loop, 2] := 63 - Trunc(63 / 27 * (Loop - 200));
                        end;
              228..255: begin
                          Palette[Loop, 0] := 63 - Trunc(63 / 28 * (Loop - 228));
                          Palette[Loop, 1] := 0;
                          Palette[Loop, 2] := 0;
                        end;
             end;
           end;
      end;
      SetPalette(Palette);
  end;

begin
  InitPalette;
  PalCount := 0;
  MomentumDiv := 1 / 50;
  SwerveAngle := 90;
  SA2 := 0;
  TempHorizon := EventHorizon;
  if Mode = 1 then TempHorizon := TempHorizon * 2;
  for Loop := 1 to NumStars do
    NewStar(Stars[Loop], SwerveAngle);
  MouseStatus(OMX, OMY, MLeft, MMiddle, MRight);
  QuitLoop := False;
  PulseUp := True;
  while not QuitLoop do
  begin
    if Move then
    begin
      CenterX := Trunc((GetMaxX div 2) * SinTable[SwerveAngle]) + (GetMaxX div 2);
      CenterY := Trunc((GetMaxY div 2) * CosTable[SA2]) + (GetMaxY div 2);
    end;
    Cls(VirtualPage, 0);
    for Loop := 1 to NumStars do
    begin
      Stars[Loop].Angle := Stars[Loop].Angle + (Stars[Loop].Speed * (Stars[Loop].Distance * MomentumDiv));
      TempAngle := Trunc(Stars[Loop].Angle);
      if TempAngle > 718 then TempAngle := TempAngle mod 718;
      if TempAngle < 0 then Validate(TempAngle);

      if Mode = 0 then
        Stars[Loop].Distance := Trunc(Stars[Loop].Distance - (Gravity - (Stars[Loop].Distance div 150)))
      else if Mode = 1 then
        Stars[Loop].Distance := Stars[Loop].Distance - Trunc(Stars[Loop].Distance / (Gravity * (TempHorizon / 5)));

      if (Stars[Loop].Distance < TempHorizon) then NewStar(Stars[Loop], SwerveAngle);
      if (Stars[Loop].Distance > (CenterX + 30)) then NewStar(Stars[Loop], SwerveAngle);

      XPos := Trunc(Stars[Loop].Distance * CosTable[TempAngle]) + CenterX;
      YPos := Trunc(Stars[Loop].Distance * SinTable[TempAngle]) + CenterY;

      if Shimmer then
        PutPixel(VirtualPage, XPos, YPos, Stars[Loop].Distance - Random(Stars[Loop].Distance - 2))
      else
        PutPixel(VirtualPage, XPos, YPos, Stars[Loop].Distance);
    end;
    if Swerve then
    begin
      SwerveAngle := SwerveAngle + StopSpeed;
      if SwerveAngle > 718 then SwerveAngle := SwerveAngle mod 718;
      SA2 := SA2 + Random(StopSpeed * 2) + StopSpeed;
      if SA2 > 718 then SA2 := SA2 mod 718;
    end;
    if PulsePal then
      if ColourScheme = 6 then
        RotatePalU(Palette, 1, 255)
      else
      begin
        if PulseUp then PalCount := PalCount + 1 else PalCount := PalCount - 1;
        if PalCount = 0 then PulseUp := True;
        if PalCount = 100 then PulseUp := False;
        if PulseUp then
          RotatePalU(Palette, 1, 255)
        else
          RotatePalD(Palette, 1, 255);
      end;
    ScreenCopy(VirtualPage, 0);
    QuitLoop := ExitRequired(OMX, OMY);
  end;
end;

begin
  InitTables(SinTable, CosTable);
  CenterX := GetMaxX div 2;
  CenterY := GetMaxY div 2;
  New(VirtualPage);
  VGAMode;
  Cls(VirtualPage, 0);
  ScreenCopy(VirtualPage, 0);
  Randomize;
  BlackHole;
  TextScrn;
  Dispose(VirtualPage);
end.